/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal;

import cnrg.itx.signal.SignalEvent.*;

/** This interface defines the methods that applications need to implement in order to use 
 *  the non-blocking dial functionality.
 */
public interface SignalConnectionObserver
{
	/**
	 * This method informs the application that the peer application has accepted
	 * the call and is ready to talk.  The appliction can now get the SignalConnection
	 * and open it for communication.
	 * 
	 * @param dse is the DialSignalEvent that contains all the information about
	 * the peer.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DialSignalEvent
	 */
	public void onAccept(DialSignalEvent dse);
	
	/**
	 * This method informs the application that the peer application has rejected
	 * the invitation to talk.
	 * 
	 * @param dse is the DialSignalEvent that contains all the information about
	 * the peer.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DialSignalEvent
	 */
	public void onReject(DialSignalEvent dse);

	/**
	 * This method informs the application that the peer application responded with
	 * an indication that it was busy and cannot talk at present.
	 * 
	 * @param dse is the DialSignalEvent that contains all the information about
	 * the peer.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DialSignalEvent
	 */
	public void onBusy(DialSignalEvent dse);
	
	/**
	 * This method informs the application that the peer application is invalid.
	 * 
	 * @param dse is the DialSignalEvent that contains all the information about
	 * the peer.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DialSignalEvent
	 */
	public void onInvalid(DialSignalEvent dse);
	
	/**
	 * This method informs the application that the peer application is not responding
	 * so the call should be aborted.
	 * 
	 * @param dse is the DialSignalEvent that contains all the information about
	 * the peer.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DialSignalEvent
	 */
	public void onTimeout(DialSignalEvent dse);
	
	/**
	 * This method informs the application that the peer application is incompatible.
	 * 
	 * @param dse is the DialSignalEvent that contains all the information about
	 * the peer.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DialSignalEvent
	 */
	public void onIncompatible(DialSignalEvent dse);
	
	/**
	 * This method informs the application that an unclassified error occurred during the
	 * dial attempt.
	 * 
	 * @param dse is the DesktopSignalingException that was thrown during the dial sequence
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.DesktopSignalingException
	 */
	public void onError(DesktopSignalingException dse);
}
